#include "Adafruit_Thermal.h"
#include "SoftwareSerial.h"

#define TX_PIN 2 // Arduino transmit to the thermal printer
#define RX_PIN 3 // Arduino receive from the thermal printer

SoftwareSerial mySerial(RX_PIN, TX_PIN); // Create a SoftwareSerial object
Adafruit_Thermal printer(&mySerial); // Initialize the thermal printer

void setup() {
  Serial.begin(9600);

  // Initialize SoftwareSerial for the thermal printer
  mySerial.begin(9600);

  // Initialize the thermal printer
  printer.begin();

  // Clear any residual data from the printer
  printer.feed(2);
  printer.flush();
}

void loop() {
  if (Serial.available() > 0) {
    String input = Serial.readString();

    // Print the received text on the thermal printer
    printer.setSize('L'); // You can adjust the text size ('S' for small, 'M' for medium, 'L' for large)
    printer.justify('C'); // Center-align the text

    // Print the input on the thermal printer
    printer.println("BARNWAL GENERAL STORE");
    printer.setSize('M'); // You can adjust the text size ('S' for small, 'M' for medium, 'L' for large)
    printer.justify('L');
    printer.println(input);


    printer.sleep();      // Tell printer to sleep
    delay(3000L);         // Sleep for 3 seconds
    printer.wake();       // MUST wake() before printing again, even if reset
    printer.setDefault(); // Restore printer to defaults
  }
}
